# Encode using PKL file (default configuration)
python embed_detect_watermark_generation.py --mode encode \
  --output_dir videoseal_pixmo_challenge_emu_edit \
  --model_type videoseal \
  --watermark_strength 1.2 \
  --text_compressor llmzip_opt125m \
  --num_texts 1000 \
  --target_psnr 42.0

# Encode using Swift model
python embed_detect_watermark_generation.py --mode encode \
  --output_dir swift_pixmo_challenge_emu_edit \
  --model_type swift \
  --model_name nautilus_256_900 \
  --text_compressor pixmo_robust_0.01_best \
  --num_texts 1000 \
  --target_psnr 42.0

python embed_detect_watermark_generation.py --mode extract \
  --watermarked_dir /home/gevennou/BIG_storage/Paper3/ip2p_videoseal_watermarked_edited \
  --correspondence_file videoseal_pixmo_challenge_emu_edit/correspondence.json \
  --output_dir videoseal_pixmo_extraction_results \
  --model_type videoseal 

# Extract and compare
python embed_detect_watermark_generation.py --mode extract \
  --watermarked_dir /home/gevennou/BIG_storage/Paper3/ip2p_swift_watermarked_edited \
  --correspondence_file swift_pixmo_challenge_emu_edit/correspondence.json \
  --output_dir swift_pixmo_extraction_results \
  --model_type swift \
  --text_compressor 'pixmo_robust_0.01_best'

python embed_detect_watermark_generation.py --mode extract \
  --watermarked_dir /home/gevennou/BIG_storage/Paper3/hidream_videoseal_watermarked_edited \
  --correspondence_file videoseal_pixmo_challenge_emu_edit/correspondence.json \
  --output_dir hidream_videoseal_pixmo_extraction_results \
  --model_type videoseal 

# Extract and compare
python embed_detect_watermark_generation.py --mode extract \
  --watermarked_dir /home/gevennou/BIG_storage/Paper3/hidream_swift_watermarked_edited \
  --correspondence_file swift_pixmo_challenge_emu_edit/correspondence.json \
  --output_dir hidream_swift_pixmo_extraction_results \
  --model_type swift \
  --text_compressor 'pixmo_robust_0.01_best'
