# Activate your environment
source venv/bin/activate

#remember to change videoseal/utils/dist.py to adapt number of gpus

cd videoseal/
# Run the distributed training with torchrun
torchrun --nproc_per_node=1 --master_port=29508\
    train.py \
    --local_rank 0 \
    --video_dataset none \
    --image_dataset coco \
    --workers 24 \
    --extractor_model convnext_tiny \
    --embedder_model unet_small2_yuv_quant \
    --hidden_size_multiplier 1 \
    --nbits -256 \
    --scaling_w_schedule Cosine,scaling_min=0.2,start_epoch=200,epochs=200 \
    --scaling_w 1.0 \
    --scaling_i 1.0 \
    --attenuation jnd_1_1 \
    --epochs 1200 \
    --iter_per_epoch 1000000 \
    --scheduler CosineLRScheduler,lr_min=1e-6,t_initial=1000,warmup_lr_init=1e-8,warmup_t=20 \
    --optimizer AdamW,lr=5e-4 \
    --lambda_dec 1.0 \
    --lambda_d 0.1 \
    --lambda_i 0.1 \
    --perceptual_loss yuv \
    --num_augs 2 \
    --augmentation_config configs/all_augs.yaml \
    --disc_in_channels 1 \
    --disc_start 50 \
    --batch_size 64 \
    --resume_from videoseal/y_256b_img.pth \
    --output_dir semanticseal_256 \
    --img_size 256 \
    --img_size_val 256 \
    --img_size_proc 256 \

