# Privacy-Aware Data Integration for Enhanced Quantile Inference under Heterogeneity

The experiment codes of the paper **Privacy-Aware Data Integration for Enhanced Quantile Inference under Heterogeneity**.

 
## File Structure
```{bash}
DataInteLDP/
├── DPQuantile.py              # Base LDP quantile estimator
├── MultiChainDPQuantile.py    # Multi-chain LDP estimator
├── util.py                    # Shared helper routines (sampling, plotting, IO)
├── TransferDPQuantile.py      # Data integration LDP estimator
├── util_di.py                 # Integration-specific helper functions
├── method.py                  # Baseline methods
├── method_lasso.py            # Baseline with Lasso-style bias correction
├── case_bias.py               # Heterogeneous bias scenario
├── case_bias_target.py        # Bias scenario, target-site focus
├── case_gbias.py              # General heterogeneous bias scenario
├── case_gbias_target.py       # General heterogeneous bias scenario, target-site focus
├── case_r.py                  # Response-rate heterogeneity
├── case_r_consvar.py          # Response-rate heterogeneity with conservative variance estimator
├── comp.py                    # Main comparison of proposed vs. baselines
├── comp_target.py             # Same as above, target-site focus
├── comp_cons.py               # Comparison under conservative settings
├── comp_consvar.py            # Comparison with conservative variance estimator
├── run.sh                     # Batch script to execute all above cases
├── requirements.txt           # Python package dependencies
└── README.md                  # Project documentation (this file)
```


## Quick Start
```bash
# 1. Install dependencies (recommended in a fresh venv)
$ pip install -r requirements.txt

# 2. Run the full experiment suite (may take several hours)
$ bash run.sh &
```
