import numpy as np
import sys
from util_di import *
from TransferDPQuantile import TransferDPQuantile
from DPQuantile import DPQuantile
import ray
import time 
import itertools
import pickle as pkl
from pathlib import Path
import pandas as pd
import copy
from itertools import product
from MultiChainDPQuantile import MultiChainDPQuantile

def train_inv(seed=None,
                   dist_type='normal', tau=0.5, rs=None,
                   K_base=5, n_samples=1000, n_sites=3, 
                   source_prop=1.0,          
                   biases=None,
                   burn_in_ratio=0, c0=1, a=0.6,b0=0):

    np.random.seed(seed)
    
    n_n_samples = get_n_n_sample(n_sites, n_samples, source_prop)

    datas, true_qs = generate_federate_data(dist_type, tau, n_n_samples,
                                   biases)
    
    K_list = get_prop_K(datas, K_base=K_base)

    model_consvar = TransferDPQuantile(K_list=K_list,
                               rs=rs, tau=tau, true_q=true_qs[0], 
                               burn_in_ratio=burn_in_ratio,
                               c0=c0, a=a, b0=b0)

    model_consvar.fit(datas)
    consvar_weights, consvar_est, consvar_var = model_consvar.aggregate(lambd=1, method='consvar')

    
    return {
        'true_qs': true_qs,
        'consvar_weights': consvar_weights,
        'consvar_est': consvar_est,
    'consvar_var':consvar_var}

@ray.remote
def train_inv_remote(**kwargs):
    return train_inv(**kwargs)

def run_simulation_inv(n_simu=100,base_seed=2025, 
                            dist_type='normal', tau=0.5, rs=None,
                            K_base=5,
                            n_samples=1000,  n_sites=3, 
                            source_prop=1.0,
                            biases=None,
                            burn_in_ratio=0, c0=1, a=0.6,b0=0):

    futures = [
        train_inv_remote.remote(
            seed=base_seed + i,
            dist_type=dist_type, tau=tau, rs=rs,
            K_base=K_base, n_samples=n_samples, n_sites=n_sites,
            source_prop=source_prop,
            biases=biases,
            burn_in_ratio=burn_in_ratio, c0=c0, a=a, b0=b0
        )
        for i in range(n_simu)
    ]        

    results = ray.get(futures)
    
    true_qs            = np.asarray(results[0]['true_qs'])
        
    consvar_weights = np.asarray([r['consvar_weights']  for r in results])
    consvar_est    = np.asarray([r['consvar_est']    for r in results])
    consvar_var  = np.asarray([r['consvar_var']  for r in results])

    return dict(true_qs=true_qs,
                consvar_weights=consvar_weights,
                consvar_est=consvar_est,
               consvar_var=consvar_var)