function [Objs,Decs] = JSEMO_MainCode(DataName,MaxIteration,PopSize,Decs)

%% Detimine the Objectives that you want
% 1 implyes the coressponding objective is selected
% 0 implyes the coressponding objective is ignored

% 1. Accuracy,    Acc
% 2. Sensitivity, Sen
% 3. Specificity, Sep
% 4. Precision,   Per
% 5. F1_score,    F1s
% 6. AUC,         Auc
% 7. Gmean        Gmn

% 8. Number of Selected Features: NSF

%            [ Acc, Sen, Sep, Per, F1s, Auc, Gmn, NSF]
Global.Objs = [ 1,   0,  0,   0,   0,   0,  0,   1];
%% Select Parameter
Global.MaxIt = MaxIteration;     % Popualtion size
Global.N = PopSize;         % Maximum generation
Global.Sim = 0.3;
Global.M = sum(Global.Objs);       % number of Objectives
Global.Show = 0;    % A Option for dispalaing during the search
Global.ClassificationMethod = 'Knn2w';

%% Select Data and Cost Function
% ori_data = load(DataName);
% data = [ori_data.X,ori_data.Y];
Global.SelectData = DataName;

%% Run JSEMO Algorithm
Global = SelctKnn2WModel(Global);
BestSolotion = JSEMO_Function(Global,Decs);
Objs = [];
Decs = [];
for m=1:size(BestSolotion,1)
    Objs = [Objs;BestSolotion(m).Objectives];
    Decs = [Decs;BestSolotion(m).Position];
end
Objs(:,2) = Objs(:,2) ./ Global.D;
% Objs(:,2) = sum(Decs,2) ./ Global.D;

end