function [rbm,allZero,allOne] = ModelTraining(Mask)
% Training RBM and DAE

    %% Determine the size of hidden layers
    allZero = all(~Mask,1);
    allOne  = all(Mask,1);
    other   = ~allZero & ~allOne;
    K       = sum(mean(abs(Mask(:,other))>1e-6,1)>rand(1,sum(other)));
    K       = min(max(K,1),size(Mask,1));
    
    %% Train RBM and DAE
    rbm = RBM(sum(other),K,10,1,0,0.5,0.1);
    rbm.train(Mask(:,other));
end