function OffMask = Operator1(Population,Mask)
% The operator of MOEA/PSL

    %% Parameter setting
    Objs = Population.objs;
    F1 = Objs(:,1);
    [~,index] = sort(F1);
    a = zeros(1,length(F1));
    for i = 1:length(F1)
        if mod(i, 2) == 1
            a(i) = 1;
        end
    end
    Parent1Mask= Mask(index(a==1),:);
    Parent2Mask = Mask(index(a==0),:);
    % Parent1Mask = Parent1Mask((1:end/2),:);
    % Parent2Mask = Parent2Mask((1:end/2),:);
    
    %% Binary variation
    OffMask = BinaryCrossover(Parent1Mask,Parent2Mask);
    % OffMask = SinglePointCrossover(Parent1Mask,Parent2Mask);
    OffMask = BinaryMutation(OffMask);
    [N,D]   = size(Parent1Mask);
    flag = sum(OffMask, 2) == 0;
    if sum(flag, 1) > 0
        OffMask(flag, 1:end) = randi([0,1], sum(flag, 1), D);
    end
    OffMask = unique(OffMask, 'rows');
    OffMask = OffMask(sum(OffMask,2)>0, 1:end);

end

function Offspring = BinaryCrossover(Parent1,Parent2)
% Uniform crossover

    k = rand(size(Parent1)) < 0.5;
    Offspring1    = Parent1;
    Offspring2    = Parent2;
    Offspring1(k) = Parent2(k);
    Offspring2(k) = Parent1(k);
    Offspring     = [Offspring1;Offspring2];
end

function Offspring = SinglePointCrossover(Parent1,Parent2)
% Single-point crossover
    [N,D]   = size(Parent1);
    k = repmat(1:D, N, 1) > repmat(randi(D, N, 1), 1, D);
    k(repmat(rand(N,1)>1,1,D)) = false;
    Offspring1    = Parent1;
    Offspring2    = Parent2;
    Offspring1(k) = Parent2(k);
    Offspring2(k) = Parent1(k);
    Offspring     = [Offspring1; Offspring2];
end

function Offspring = BinaryMutation(Offspring)
% Bitwise mutation
    % if rand < 0.5
        Site = rand(size(Offspring)) < 1/size(Offspring,2);
        Offspring(Site) = ~Offspring(Site);
    % else
    %     bit = TournamentSelection(5,size(Offspring,1),Fitness);
    %     Offspring(:,bit) = 1;
    % end
end