function OffMask = OperatorRBM(ParentMask,rbm,allZero,allOne)
% The operator of MOEA/PSL

    %% Parameter setting
    Parent1Mask = ParentMask(1:end/2,:);
    Parent2Mask = ParentMask(end/2+1:end,:);
    
    %% Binary variation
    other   = ~allZero & ~allOne;
    OffTemp = BinaryCrossover(rbm.reduce(Parent1Mask(:,other)),rbm.reduce(Parent2Mask(:,other)));
    OffTemp = rbm.recover(OffTemp);
    OffMask = false(size(OffTemp,1),size(Parent1Mask,2));
    OffMask(:,other)  = OffTemp;
    OffMask(:,allOne) = true;
    OffMask = BinaryMutation(OffMask);
    OffMask = unique(OffMask, 'rows');
    OffMask = OffMask(sum(OffMask,2)>0, 1:end);
end

function Offspring = BinaryCrossover(Parent1,Parent2)
% Uniform crossover

    k = rand(size(Parent1)) < 0.5;
    Offspring1    = Parent1;
    Offspring2    = Parent2;
    Offspring1(k) = Parent2(k);
    Offspring2(k) = Parent1(k);
    Offspring     = [Offspring1;Offspring2];
end

function Offspring = BinaryMutation(Offspring)
% Bitwise mutation

    Site = rand(size(Offspring)) < 1/size(Offspring,2);
    Offspring(Site) = ~Offspring(Site);
end