from gym_minigrid.minigrid import *
from gym_minigrid.register import register

from .base import SimpleEnv

class SimpleLineEnv(SimpleEnv):

    def __init__(
        self,
        size=8,
        agent_start_pos=None,
        agent_start_dir=0,
    ):
        size = size+2
        self.agent_start_pos = (1, 1) if not None else agent_start_pos
        self.agent_start_dir = agent_start_dir
        self._init_pos = None

        super().__init__(
            width=size,
            height=3,
            max_steps=4*size,
            # Set this to True for maximum speed
            see_through_walls=True
        )

    def _gen_grid(self, width, height):
        # Create an empty grid
        self.grid = Grid(width, height)

        # Generate the surrounding walls
        self.grid.wall_rect(0, 0, width, height)

        # Place a goal square in the bottom-right corner
        self.put_obj(Goal(), width - 2, 1)

        # Place the agent
        if self.agent_start_pos is not None:
            self.agent_pos = self.agent_start_pos
            self.agent_dir = self.agent_start_dir
            self._init_pos = self.agent_start_pos
        else:
            self._init_pos = self.place_agent()

        self.mission = "get to the green goal square"

    def _reward(self):
        """
        Compute the reward to be given upon success
        """
        min_step_count_to_goal = self._compute_min_step_count_to_goal()
        return min_step_count_to_goal / self.step_count

    def _compute_min_step_count_to_goal(self):
        j, i = self._init_pos
        return self.width - 2 - j


class SimpleLineEnv3(SimpleLineEnv):
    def __init__(self, **kwargs):
        super().__init__(size=3, **kwargs)

class SimpleLineRandomEnv3(SimpleLineEnv):
    def __init__(self):
        super().__init__(size=3, agent_start_pos=None)

class SimpleLineEnv4(SimpleLineEnv):
    def __init__(self, **kwargs):
        super().__init__(size=4, **kwargs)

class SimpleLineRandomEnv4(SimpleLineEnv):
    def __init__(self):
        super().__init__(size=4, agent_start_pos=None)

class SimpleLineEnv5(SimpleLineEnv):
    def __init__(self, **kwargs):
        super().__init__(size=5, **kwargs)

class SimpleLineRandomEnv5(SimpleLineEnv):
    def __init__(self):
        super().__init__(size=5, agent_start_pos=None)

class SimpleLineEnv10(SimpleLineEnv):
    def __init__(self, **kwargs):
        super().__init__(size=10, **kwargs)

class SimpleLineRandomEnv10(SimpleLineEnv):
    def __init__(self):
        super().__init__(size=10, agent_start_pos=None)

class SimpleLineEnv20(SimpleLineEnv):
    def __init__(self, **kwargs):
        super().__init__(size=20, **kwargs)

class SimpleLineRandomEnv20(SimpleLineEnv):
    def __init__(self):
        super().__init__(size=20, agent_start_pos=None)

register(
    id='MiniGrid-SimpleLine-3-v0',
    entry_point='custom_minigrid.envs:SimpleLineEnv3'
)

register(
    id='MiniGrid-SimpleLine-Random-3-v0',
    entry_point='custom_minigrid.envs:SimpleLineRandomEnv3'
)

register(
    id='MiniGrid-SimpleLine-4-v0',
    entry_point='custom_minigrid.envs:SimpleLineEnv4'
)

register(
    id='MiniGrid-SimpleLine-Random-4-v0',
    entry_point='custom_minigrid.envs:SimpleLineRandomEnv4'
)

register(
    id='MiniGrid-SimpleLine-5-v0',
    entry_point='custom_minigrid.envs:SimpleLineEnv5'
)

register(
    id='MiniGrid-SimpleLine-Random-5-v0',
    entry_point='custom_minigrid.envs:SimpleLineRandomEnv5'
)

register(
    id='MiniGrid-SimpleLine-10-v0',
    entry_point='custom_minigrid.envs:SimpleLineEnv10'
)

register(
    id='MiniGrid-SimpleLine-Random-10-v0',
    entry_point='custom_minigrid.envs:SimpleLineRandomEnv10'
)

register(
    id='MiniGrid-SimpleLine-20-v0',
    entry_point='custom_minigrid.envs:SimpleLineEnv20'
)

register(
    id='MiniGrid-SimpleLine-Random-20-v0',
    entry_point='custom_minigrid.envs:SimpleLineRandomEnv20'
)

