import joblib
import numpy as np
from imblearn import FunctionSampler
from imblearn.combine import SMOTETomek
from imblearn.over_sampling import SMOTE
from imblearn.pipeline import Pipeline
from sklearn.tree import DecisionTreeClassifier


def _make_sl_classifier():
    
    def action_resampler(X, y):
        """This will be our function used to resample our dataset."""
        smote = SMOTE(
            k_neighbors=1,
        )
        model = SMOTETomek(smote=smote)
        ix = np.arange(X.shape[0]).reshape(-1, 1)
        actions = X[..., 0:4].argmax(axis=-1)

        # Resample all together
        labels = actions * 10 + y

        ix_resampled, _ = model.fit_resample(ix, labels)
        ix_resampled = ix_resampled.squeeze()
        X_resampled, y_resampled = X[ix_resampled,], y[ix_resampled]

        indices = np.random.permutation(X_resampled.shape[0])
        X_resampled = X_resampled[indices]
        y_resampled = y_resampled[indices]

        return X_resampled, y_resampled


    model = Pipeline([
        ("actions_sampler", FunctionSampler(func=action_resampler)),
        ("classifier", DecisionTreeClassifier()),
    ])

    def _save_override(self, path):
        estimators = self.steps
        model_to_save = Pipeline(estimators[-1:])
        joblib.dump(model_to_save, path)

    model.save = _save_override

    def _load_override(self, path, **kwargs):
        classifier = joblib.load("DecisionTreeClassifier.joblib")
        self.steps = classifier.steps
    
    model.load = _load_override

    return model

InapplicableActionsClassifier = _make_sl_classifier
