from gym_minigrid.minigrid import *
from gym_minigrid.register import register

from .base import SimpleEnv

class SimpleEmptyEnv(SimpleEnv):
    """
    Empty grid environment, no obstacles, sparse reward
    """

    def __init__(
        self,
        size=8,
        agent_start_pos=None,
        agent_start_dir=0,
    ):
        size = size+2
        self.agent_start_pos = (1, size-2) if not None else agent_start_pos
        self.agent_start_dir = agent_start_dir

        super().__init__(
            grid_size=size,
            max_steps=4*size*size,
            # Set this to True for maximum speed
            see_through_walls=True
        )

    def _gen_grid(self, width, height):
        # Create an empty grid
        self.grid = Grid(width, height)

        # Generate the surrounding walls
        self.grid.wall_rect(0, 0, width, height)

        # Place a goal square in the bottom-right corner
        self.put_obj(Goal(), width - 2, 1)

        # Place the agent
        if self.agent_start_pos is not None:
            self.agent_pos = self.agent_start_pos
            self.agent_dir = self.agent_start_dir
        else:
            self.place_agent()

        self.mission = "get to the green goal square"

    def _reward(self):
        """
        Compute the reward to be given upon success
        """
        min_step_count_to_goal = 8
        return min_step_count_to_goal / self.step_count


class SimpleEmptyEnv3x3(SimpleEmptyEnv):
    def __init__(self, **kwargs):
        super().__init__(size=3, **kwargs)

class SimpleEmptyRandomEnv3x3(SimpleEmptyEnv):
    def __init__(self):
        super().__init__(size=3, agent_start_pos=None)

class SimpleEmptyEnv4x4(SimpleEmptyEnv):
    def __init__(self, **kwargs):
        super().__init__(size=4, **kwargs)

class SimpleEmptyRandomEnv4x4(SimpleEmptyEnv):
    def __init__(self):
        super().__init__(size=4, agent_start_pos=None)

class SimpleEmptyEnv5x5(SimpleEmptyEnv):
    def __init__(self, **kwargs):
        super().__init__(size=5, **kwargs)

class SimpleEmptyRandomEnv5x5(SimpleEmptyEnv):
    def __init__(self):
        super().__init__(size=5, agent_start_pos=None)

class SimpleEmptyEnv6x6(SimpleEmptyEnv):
    def __init__(self, **kwargs):
        super().__init__(size=6, **kwargs)

class SimpleEmptyRandomEnv6x6(SimpleEmptyEnv):
    def __init__(self):
        super().__init__(size=6, agent_start_pos=None)

class SimpleEmptyEnv16x16(SimpleEmptyEnv):
    def __init__(self, **kwargs):
        super().__init__(size=16, **kwargs)

register(
    id='MiniGrid-SimpleEmpty-3x3-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyEnv3x3'
)

register(
    id='MiniGrid-SimpleEmpty-Random-3x3-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyRandomEnv3x3'
)

register(
    id='MiniGrid-SimpleEmpty-4x4-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyEnv4x4'
)

register(
    id='MiniGrid-SimpleEmpty-Random-4x4-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyRandomEnv4x4'
)

register(
    id='MiniGrid-SimpleEmpty-5x5-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyEnv5x5'
)

register(
    id='MiniGrid-SimpleEmpty-Random-5x5-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyRandomEnv5x5'
)

register(
    id='MiniGrid-SimpleEmpty-6x6-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyEnv6x6'
)

register(
    id='MiniGrid-SimpleEmpty-Random-6x6-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyRandomEnv6x6'
)

register(
    id='MiniGrid-SimpleEmpty-8x8-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyEnv'
)

register(
    id='MiniGrid-SimpleEmpty-16x16-v0',
    entry_point='custom_minigrid.envs:SimpleEmptyEnv16x16'
)
