#!/bin/bash

type=$1
dataset=$2
backend=$3
shots=$4
model=$5

# all args from 6 onwards
extra_args=${@:6}

# if type == 22 then pad_seq_len = 4
if [ "$type" -eq 22 ]; then
    pad_seq_len=4
else
    pad_seq_len=6
fi

micromamba activate qiskit
python eval.py --model qcnn --cnn_type $type --dataset $dataset \
    --pad_seq_len $pad_seq_len --backend $backend --shots $shots \
    --load_model $model $extra_args 

# source ./scripts/eval_qcnn.sh 33 TS ibm_strasbourg 1024 /path/to/model.npz 2>logs.txt

# source ./scripts/eval_qcnn.sh 33 MC-LM ibm_strasbourg 1024 /path/to/model.npz 2>logs.txt

# source ./scripts/eval_qcnn.sh 33 MC ibm_strasbourg 1024 /path/to/model.npz 2>logs.txt

# source ./scripts/eval_qcnn.sh 22 RP ibm_strasbourg 1024 /path/to/model.npz 2>logs.txt