#!/bin/bash

dataset=$1
backend=$2
shots=$3
model=$4

# all args from 5 onwards
extra_args=${@:5}

micromamba activate qiskit
python eval.py --model qrnn --dataset $dataset \
    --backend $backend --shots $shots --batch_size 32 --max_batches 10 \
    --load_model $model $extra_args

# source ./scripts/eval_qrnn.sh TS ibm_strasbourg 1024 /path/to/model.npz 2>logs.txt

# source ./scripts/eval_qrnn.sh MC-LM ibm_strasbourg 1024 /path/to/model.npz 2>logs.txt

# source ./scripts/eval_qrnn.sh MC ibm_strasbourg 1024 /path/to/model.npz 2>logs.txt

# source ./scripts/eval_qrnn.sh RP ibm_strasbourg 1024 /path/to/model.npz 2>logs.txt