def register(mf):
    mf.set_scope("model.resnet")
    mf.load("resnet")
    mf.register_default_module("model.resnet.blocks.*","bottleneck_post")
    mf.overwrite_defaults({
        "num_planes": [64, 128, 256, 512],
        "strides": [2, 2, 2, 2],

        # first conv layer
        "first_conv_filters": 64,
        "first_conv_kernel_size": 7,
        "first_conv_padding": 3,
        "first_conv_stride": 2,
        "first_conv_max_pool": True,

        # each element in the tuple indicates if we should replace
        # the 2x2 stride with a dilated convolution instead
        "replace_stride_with_dilation": [False, False, False],
    }, scope="model.resnet")
