import numpy as np
import torch

# static heatmap
def plot_static_hm(state, Z, X=None, Y=None, title="Heatmap", **kwargs):
    assert Z.dim() == 2
    # plotname & title
    pname = "scalar3d-"+title
    kwargs["title"] = title

    # add legend/ticks
    if "xlabel" not in kwargs:
        kwargs["xlabel"] = "X"
    if "ylabel" not in kwargs:
        kwargs["ylabel"] = "Y"

    # create/update plot
    state["WINDOWS"][pname] = state["vis"].heatmap(
        Z.T,
        win=pname,
        opts=kwargs,
        # opts={'layoutopts': {'plotly': {'xaxis': dict(autorange=True, showgrid=False, zeroline=False, showline=False,autotick=True,ticks='',showticklabels=False)}}}
    )


