from tqdm import tqdm
import torch

def linspace_dataloader(state):
    steps = state["steps"]
    dataset = torch.linspace(state["from"],state["to"],steps).reshape([-1,1])
    trainloader = torch.utils.data.DataLoader([dataset,dataset], batch_size=steps, shuffle=False)
    return trainloader, trainloader, trainloader

def register(mf):
    mf.set_scope("dataset")
    mf.register_defaults({
        "num_channels": 1,
        "num_classes": 1,
        "from": -0.25,
        "to": 0.25,
        "steps": 1000
    })

    mf.register_event('dataloader', linspace_dataloader, unique=True)
