from torch import nn

def activation(state, event):
    return nn.Hardtanh(min_val=state["minval"],max_val=state["maxval"])

def init_conv(state,event,m):
    nn.init.kaiming_normal_(m.weight, mode='fan_out')
def register(mf):
    mf.register_event('activation_layer_cls', lambda:nn.Hardtanh, unique=True)
    mf.register_event('activation_layer', activation, unique=True)
    mf.register_event('init_conv', init_conv, unique=True)
    mf.register_defaults({
        "minval": -1,
        "maxval":1,
    })