def register(mf):
    mf.register_default_module("normalization.*", "batchnorm")
    mf.register_default_module("activations.*", "relu")
    mf.register_default_module("model.*", "resnet56")
    mf.register_default_module(".*experiments\.(?!sotacifar10$).*", "train")
    mf.register_default_module("data.dataset.*","cifar10")
    mf.load(["optimizer","augment","gpu","multistep", "validate"])
    mf.register_helpers({
        "main.epochs": 0
    }, scope="")
    mf.overwrite_globals({

        # Optimizer and scheduler
        "optimizer.learning_rate": 0.1,
        "optimizer.weight_decay": 1e-4,
        "optimizer.momentum": 0.9,
        "main.epochs": 200,
        "data.cpuloader.batchsize": 128,
        "scheduler.multistep.milestones": [100,150],
        "scheduler.multistep.gamma": 0.1,

        # Augmentation
        "data.augment.flip": True,
        "data.augment.cropsize": 32,
        "data.augment.croppadding": 4,
        "data.augment.rotationdeg": 0,

        # Validation
        "data.cpuloader.val_prop": 0.01,
        "data.cpuloader.drop_last": False,
        })

