import torch
from tqdm import tqdm, trange
from moduleloader import outervar, like


def main(state, event):

    # load dataset
    trainloader, testloader, valloader = event.dataloader()

    # iterate over depths
    for current_depth in tqdm(state["depths"], position=1, desc="Network Depth"):

        # get network
        net = event.init_net(current_depth)

        # optionally load checkpoint
        event.optional_unique.load_ckpt(net)

        # send to device
        net = event.send_net_to_device(net)

        # get criterion
        criterion = event.init_loss()
        criterion = event.send_loss_to_device(criterion)

        # optional events (typically optimizer, learning rate scheduler, aso.)
        event.optional.before_training()

        # actual measurements
        event.optional.measure()

def register(mf):
    mf.register_helpers({
        "depths": like("_.depths",list(range(1,10))),
    })
    mf.register_event('main', main)


