def register(mf):
    mf.set_scope("model.resnet")
    mf.load("resnet")
    mf.register_default_module("model.resnet.blocks.*","basicblock_post")
    mf.overwrite_defaults({
        "num_planes": [16, 32, 64],
        "strides": [1,2,2],

        # first conv layer
        "first_conv_filters": 16,
        "first_conv_kernel_size": 3,
        "first_conv_padding": 1,
        "first_conv_stride": 1,
        "first_conv_max_pool": False,

        # each element in the tuple indicates if we should replace
        # the 2x2 stride with a dilated convolution instead
        "replace_stride_with_dilation": [False, False],
    }, scope="model.resnet")
