import torch.optim as optim

def init_optimizer(state, event, net,parameters=None):
    if not parameters:
        parameters = net.parameters()

    optimizer = optim.SGD(parameters, lr=state["learning_rate"], momentum=state["momentum"], weight_decay=state["weight_decay"])
    return optimizer

def register(mf):
    mf.set_scope("optimizer")
    mf.register_defaults({
        "learning_rate": 1e-2,
        "momentum": 1e-3,
        "weight_decay": 1e-3,
    })
    mf.register_event('init_optimizer', init_optimizer, unique=True)
