from .network import Net

def register(mf):
    mf.register_defaults({
        "short": False,
        "filters": 32,
        "depth": 16,
        "layers": lambda state, event: [state['experiments.1d-net.net.filters'] for i in range(state['experiments.1d-net.net.depth'])]
    })
    mf.register_helpers({
        "last_layer": True
    })
    mf.register_event("init_net", Net, unique=True)
