#!/bin/python
import sys
import os
sys.path.insert(0, os.path.join("moduleloader","src"))
import moduleloader as kindermaxiflask

# check if user tries to profile this script
import torch
if "torch.utils.bottleneck" in sys.modules:
    print("BOTTLENECK MODE")
    torch.multiprocessing.set_start_method('spawn', force="True")
torch.backends.cudnn.benchmark=True

# init moduleloader
mf = kindermaxiflask.init(
    module_dirs=["./grp_modules", "./lola_modules"]
)

# parse cli arguments
mf.parse_args()

# load autoload modules for this project
mf.load([
    "settings"
])

mf.run()
