import torchvision.transforms as transforms

def dataset_transform(state, event, splitname):
    T = []

    if splitname == "train":
        if state["flip"]:
            T.append(
                transforms.RandomHorizontalFlip(),
            )
        if state["cropsize"] > 0:
            T.append(
                transforms.RandomCrop(state["cropsize"], padding=state["croppadding"]),
            )
        if state["rotationdeg"] > 0:
            T.append(
                transforms.RandomRotation(size=state["rotationdeg"]),
            )

    return T


def register(mf):
    mf.register_defaults({
        "cropsize": 32,
        "croppadding": 4,
        "flip": True,
        "rotationdeg": 0
    })
    mf.register_event('dataset_transform', dataset_transform)
