from .network import Net

def register(mf):
    mf.register_defaults({
        "filters": 32,
        "depth": 16,
        "stride": 2,
        "conv_blocks": lambda state, event: [state['model.convnet.filters'] for i in range(state['model.convnet.depth'])],
        "short": False,
        "first_stride":5,
        "resblock_size":1,
    })
    mf.register_event("init_net", Net, unique=True)
