import torch.optim as optim

def init_optimizer(state, event, net,parameters=None):
    if not parameters:
        parameters = net.parameters()
    return optim.Adam(parameters, lr=state["learning_rate"], weight_decay=state["weight_decay"])

from torch import nn

def register(mf):
    mf.set_scope("optimizer")
    mf.register_defaults({
        "learning_rate": 1e-2,
        "weight_decay": 1e-3,
    })
    mf.register_event('init_optimizer', init_optimizer, unique=True)
