import numpy as np

def plot_scalar(state, Y, X=None, title="Scalar", autohalf=0, **kwargs):
    if X is None:
        X = state.all["step"]
    # if autohalf is None:
    #     autohalf = state["autohalf"]

    # plotname & title
    pname = "scalar-"+title
    kwargs["title"] = title

    # assure right format
    if not isinstance(Y,np.ndarray):
        Y = np.array(Y).reshape([-1])
        if len(Y) > 1 and autohalf > 0:
            raise ValueError("autohalf only implemented for len(Y) == 1")
    if not isinstance(X,np.ndarray):
        X = np.array(X).reshape([-1])

    # helper object
    append = True if pname in state["WINDOWS"] and len(X) == 1 else False
    # if autohalf > 0:
    #     if pname in state["WINDOWS"]:
    #         obj = state["WINDOWS"][pname] 
    #         obj["X"].append(X[0])
    #         obj["Y"].append(Y[0])
    #     else:
    #         state["WINDOWS"][pname] = obj = {
    #             "X": [X[0]],
    #             "Y": [Y[0]],
    #             "scale": 1
    #         }
    # else:
    obj = state["WINDOWS"][pname]  = {}

    # merge results ?
    # if autohalf > 0 and len(obj["X"]) > autohalf:
    #     Y = (np.array(obj["Y"][1::2])+np.array(obj["Y"][0:-1:2]))/2
    #     X = (np.array(obj["X"][1::2])+np.array(obj["X"][0:-1:2]))/2
    #     obj["Y"] = Y.tolist()
    #     obj["X"] = X.tolist()
    #     append = False

    # shall append ?
    update_kwarg = dict(update="append") if append else {}

    # create/update plot
    state["vis"].line(
        Y=Y,
        X=X,
        win=pname,
        opts=kwargs,
        **update_kwarg
    )


