from torch import nn

def activation(state, event):
    return nn.PReLU(init=state["init"])


def init_conv(state,event,m):
    nn.init.kaiming_normal_(m.weight, a=state["init"], mode='fan_out', nonlinearity='leaky_relu')

def register(mf):
    mf.register_event('activation_layer_cls', lambda:nn.PReLU, unique=True)
    mf.register_event('activation_layer', activation, unique=True)
    mf.register_event('init_conv', init_conv, unique=True)
    mf.register_defaults({
        "init": 0.25,
    })