import torch
import numpy as np
import sys
import random

def set_seed(state, event):
    seed = state["seed"]
    if seed >= 0:
        torch.backends.cudnn.deterministic = True
        torch.backends.cudnn.benchmark = False
        torch.manual_seed(seed)
        torch.cuda.manual_seed_all(seed)
        np.random.seed(seed)
        random.seed(seed)
    else:
        torch.backends.cudnn.benchmark = True

def register(mf):
    mf.register_defaults({
        "seed": -1              # not deterministic
    })
    mf.register_event('init', set_seed)
    mf.register_event('set_seed', set_seed)
