#!/bin/bash

# Define constant path variables
DATASET="CIFAR10"                        # Either 'CIFAR10' or 'STL10'
DATASET_ROOT="/path/to/private_data"     # Private dataset path
MODEL="resnet9"                          # 'convnet' or 'resnet9'
EPOCHS=100                               # Number of training epochs
BATCH_SIZE=64                            # Batch size
LR=5e-2                                  # Learning rate
WEIGHT_DECAY=1e-3                        # Weight decay
DEVICE="cuda:0"                          # Device to run on ('cuda:0' or 'cpu')
IMAGE_SIZE=32                            # Image size (e.g., 32 for CIFAR10)
EPSILON=1                                # Privacy budget
DELTA=1e-5                               # Privacy budget
SYN_DIR="/path/to/syn_directory"         # Directory where synthetic base images are stored
PASDA_DIR="/path/to/pasda_directory"     # Directory where PASDA generated images are stored


python 1_base_dataset_generation.py \
    --dataset $DATASET \
    --syn_dir $SYN_DIR \
    --device $DEVICE \

python 2_pasda.py \
    --dataset $DATASET \
    --private_dir $DATASET_ROOT \
    --syn_dir $SYN_DIR \
    --output_dir $PASDA_DIR \
    --device $DEVICE \
    --epsilon $EPSILON \
    --delta $DELTA

python main.py \
    --model $MODEL \
    --dataset $DATASET \
    --train_dir $PASDA_DIR \
    --epochs $EPOCHS \
    --batch_size $BATCH_SIZE \
    --lr $LR \
    --weight_decay $WEIGHT_DECAY \
    --device $DEVICE \
    --image_size $IMAGE_SIZE
