#!/usr/bin/env python
# -*- encoding: utf-8 -*-
from __future__ import absolute_import
from __future__ import print_function

import io
import re
from glob import glob
from os.path import basename
from os.path import dirname
from os.path import join
from os.path import splitext

from setuptools import find_packages
from setuptools import setup


def read(*names, **kwargs):
    with io.open(
        join(dirname(__file__), *names),
        encoding=kwargs.get('encoding', 'utf8')
    ) as fh:
        return fh.read()


setup(
    name='rbsgnn',
    version='0.0.1',
    license='MIT',
    description='Learn estimable graph parameters with random neighborhood sampling.',
    author='Anon',
    author_email='Anon',
    packages=find_packages('src'),
    package_dir={'': 'src'},
    py_modules=[splitext(basename(path))[0] for path in glob('src/*.py')],
    include_package_data=True,
    zip_safe=False,
    keywords=[
        'graph neural networks', 'random sampling', 'Benjamini-Schramm'
    ],
    python_requires='>=3.7',
    install_requires=[
        'networkx>=2.5'
    ],
)
