import networkx as nx 
import pickle as pk
import os


def load_adj(nx_graph, sparse=True):
    """Returns adj matrix from undirected graph nx_graph.

    Args:
        nx_graph: (nx.Graph) Input graph.
        sparse: (bool) Return adjacency matrix as sparse array.
    """ 
    adj = nx.adj_matrix(nx_graph)
    if not sparse:
        return adj
    else:
        return adj.toarray()


def load_picked_data(dname, dloc):
    path = os.path.abspath(dloc)
    path = os.path.join(path, dname)
    graphs = load_graphs(path)
    features = load_features(path)
    labels = load_labels(path)
    return graphs, features, labels
     

def load_pickle(pk_graph_file, ext):
    """Simple hander to load a nx graph stored in a pickle file

    Args:
        pk_graph_file: (str) .graph file location.
    """
    path = os.path.expanduser(pk_graph_file)
    path = os.path.abspath(path)
    path = path+ext
    d = None
    if os.path.exists(path):
        with open(path, "rb") as f:
            d = pk.load(f)
    return d

def load_features(path):
    return load_pickle(path, '.X')

def load_graphs(path):
    return load_pickle(path, '.graph')

def load_labels(path):
    return load_pickle(path, '.y')
