# CSO: Constraint-guided Space Optimization for Active Scene Mapping

The robot first uses the Mapping Module to construct an Exploration Map based on the Observations, and uses Information Aggregation to compute the frontiers-based entropy of each frontier. Then the State Generator generates the state input for the Global Policy. At the global planning stage, the Graph Neural Network-based encoder is used for feature fusion and extraction. Based on the sampling probabilities of frontiers output by the actor network, the Action Mask Guided Space Alignment filters unreasonable frontiers and guides the critic value space to align with the geodesic distance space. nce a frontier is selected as the long-term goal, the Local Policy drives the robot to reach this goal and update the Exploration Map based on new observations. This planning cycle is iteratively implemented until the termination criteria are triggered.

![architecture](example/pipeline.png)

<p align="center">The Overview of CSO for Active Scene Mapping.</p>
 

## BUILD

```shell
conda create -p ./venv python=3.7
source activate ./venv
sh ./build.sh && python -m gibson2.utils.assets_utils --download_assets
```

## DATASET

+ Gibson

1. get dataset [here](https://forms.gle/36TW9uVpjrE1Mkf9A)

2. copy URL of `gibson_v2_4+.tar.gz`

3. run command

  ```shell
  python -m gibson2.utils.assets_utils --download_dataset {URL}
  ```


+ Matterport3D

1. get dataset according to [README](https://github.com/StanfordVL/GibsonEnv/blob/master/gibson/data/README.md)

2. run command

  ```shell
  python2 download_mp.py --task_data igibson -o . `
  ```

3. move each folder of scenes to `Gibson Dataset path`

  You can check `Gibson Dataset path` by running

  ```shell
  python -m gibson2.utils.assets_utils --download_assets
  ```


## USAGE

+ Train

```
sh train.sh
```
or

```shell
python main.py \
--critic_lr_coef 5e-2 \
--num_robots 1 \
--num_processes 4 \
--train_global 1 \
--dump_location "train" \
--global_lr 5e-5 \
--info_mode 2 \
--info_type 1 \
--action_masked 3 \
--info_gain_map_length 60 \
--map_size_cm 4800 \
--scenes_file "scenes/mm/mp3d/train_list.scenes" \
--exp_name 'exp_1'
```

+ Test

```
sh test.sh
```
or
```shell
python main.py \
--num_robots 1 \
--num_processes 1 \
--dump_location "test" \
--info_mode 2 \
--info_type 1 \
--action_masked 3 \
--info_gain_map_length 60 \
--map_size_cm 4800 \
--vis_type 3 \
--scenes_file "scenes/mm/mp3d/test_val_list.scenes" \
--num_episodes 29 \
--save_init_pos_orn 1 \
--specify_init 0 \
--load_global "cso.global" \
--exp_name 'exp_1' \
```


## ACKNOWLEDGMENT
In this repository, we mainly conduct experiments based on the open source code of [NeuralCoMapping](https://github.com/siyandong/NeuralCoMapping). And we also use parts of the implementation from [Active Neural SLAM](https://github.com/devendrachaplot/Neural-SLAM), [SuperGlue](https://github.com/HeatherJiaZG/SuperGlue-pytorch) and [iGibson](https://github.com/StanfordVL/iGibson). We thank the respective authors for open sourcing their code.





