# Hyperbolic Deep Reinforcement Learning minimal repository

This repository contains research code for the *ICLR 2023* submission *Hyperbolic Deep Reinforcement Learning*.
This is a minimal repository meant to provide means to reproduce the main reported results.
A complete, documented version of our implementation will be open-sourced after review.

## Setup

Install dependencies via [conda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/linux.html):
```sh
conda env create -f environment.yml
conda activate procgen_hyper
```

## Replicating the results

Run experiments by executing _main_hydra.py_ and override the appropriate arguments (see [hydra](https://hydra.cc/docs/intro/) for details), e.g. to run PPO with hyperbolic representations on _starpilot_
with generalization configurations:

```setup
python main_hydra.py agent=onpolicy/hyperbolic/ppo env=gen/starpilot
```
