# Compute Polyhedral Complexes
Code used in the experiments of the NeurIPS 2025 submission "Characterizing the Combinatorial Complexity of ReLU Networks".

## Environment Setup 
1. Install Python 3.10.13
2. Install [PyTorch 2.3.0](https://pytorch.org/get-started/previous-versions/#:~:text=org/whl/cpu-,v2.3.0,-Conda)
3. Install the remaining dependencies with `pip install -r requirements.txt`

## Replication of Experimental Results

1. Run `python experiments.py` to download the datasets, train the models, and set up the experiments from the paper. Some HTTP errors are expected when fetching the datasets. GPUs are recommended at this step to speed up training, but they are not necessary for any of the following steps.
2. Run `python run_synthetic.py` to run the experiments with synthetic data. This may take days to run depending on your hardware configuration, but smaller experiments run first and the script can be interrupted at any time to work with a partial set of results.
3. Run `python combine_results.py` to combine all synthetic data results into a single DataFrame.
4. Run `python run_real.py` to run experiments with real data.
5. Run the Jupyter notebooks in the [visualization](./visualization) folder to generate the plots from the paper.

## Parallelization
The `python run_synthetic.py` script may take a long time when run on a single machine. However, the experiments easily can be parallelized across multiple nodes. To facilitate this, the script optionally takes two command line arguments that are passed to the "range()" function to select a subset of indices of experiments (0-239 by default) to run.  For example, `python run_synthetic.py 50 55` will run experiments 50, 51, 52, 53, and 54 sequentially. There is no interdependence between the runs. By default they will use however many CPUs are detected on the machine, but an optional third command line argument restricts the number of CPUs used by the script. For example, `python run_synthetic.py 0 240 32` will run all of the experiments from the paper sequentially using only 32 CPUs. These arguments simplify the process of submitting batch jobs on a cluster to run experiments in parallel.

## Code Structure
* [dataset.py](dataset.py): Dataset class and initializers
* [model.py](model.py): Model class and initializers
* [experiments.py](experiments.py): Experiment class and model training
* [run_synthetic.py](run_synthetic.py): Analyzes complexes of networks trained on synthetic data
* [run_real.py](run_real.py): Analyzes complexes of networks trained on real data
* [poly.py](poly.py): Class for calculations involving individual polyhedrons (e.g. computing boundaries, neighbors, volume)
* [decomp.py](decomp.py): Class for calculations involving the polyhedral complex (e.g. polyhedron search, dual graph calculation)
* [convert_model.py](convert_model.py): Utilities for converting various PyTorch.nn layers to Linear layers

## Obtaining a Gurobi License

**The following steps are not necessary when replicating the experiments from the paper.** 

Without a license, Gurobi will only work with a limited feature set. This includes a limit on the number of decision variables in the models it can solve, which limits the size of the networks this code is able to analyze. There are multiple ways to install a version of the software that supports the [license tools](https://support.gurobi.com/hc/en-us/articles/12872879801105-How-do-I-retrieve-and-set-up-a-Gurobi-license), one way is described below.
1. Install Gurobi through Conda with `conda install -c gurobi gurobi`
2. [Obtain a Gurobi license](https://support.gurobi.com/hc/en-us/articles/360040541251-How-do-I-obtain-a-free-academic-license) (free for academics)
3. In your Conda environment, run `grbgetkey` followed by your license key
