#!/bin/bash

#SBATCH --job-name=LP_BN
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=2
#SBATCH --mem=80GB
#SBATCH --time=48:00:00
#SBATCH --gres=gpu
#SBATCH --partition=a100_1,a100_2,v100,rtx8000

# job info
# dset=$1     # 1 | 5

# Singularity path
ext3_path=/scratch/$USER/python36/python36.ext3
sif_path=/scratch/work/public/singularity/cuda11.2.2-cudnn8-devel-ubuntu20.04.sif


# start running
singularity exec --nv \
--overlay ${ext3_path}:ro \
${sif_path} /bin/bash -c "
source /ext3/env.sh
python -m office-home.train_tar --dset a2c --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15
python -m office-home.train_tar --dset a2p --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15
python -m office-home.train_tar --dset a2r --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15

python -m office-home.train_tar --dset c2a --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15
python -m office-home.train_tar --dset c2p --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15
python -m office-home.train_tar --dset c2r --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15

python -m office-home.train_tar --dset p2a --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15
python -m office-home.train_tar --dset p2c --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15
python -m office-home.train_tar --dset p2r --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15

python -m office-home.train_tar --dset r2a --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15
python -m office-home.train_tar --dset r2c --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15
python -m office-home.train_tar --dset r2p --loss_type dot --loss_wt nn5 --lp_type 0.5 --data_trans mn --data_aug 0.2,0.5 --div_wt 0.1 --fuse_af 15 --lr_scale 0.5 --exp_name lp_nn5_mn_lp05_div01_af15

"
