import hydra
from omegaconf import DictConfig, OmegaConf

from tabdd.config.paths import RUN_CONFIG_DIR

@hydra.main(
    version_base=None, 
    config_path=RUN_CONFIG_DIR, 
    config_name="test"
)
def test(config: DictConfig):
    print(OmegaConf.to_yaml(config))
    hydra.utils.instantiate(
        config.distill.methods.Agglo
    )

if __name__ == '__main__':
    test()