#!/bin/bash
export PYTHONPATH='.'

base_model="models--baffo32--decapoda-research-llama-7B-hf/snapshots/aa18b48a1330572a6dd5f5d5619ed19838ca285c"
target_module="qkvupdown"
tune_ckpt_path="vb_lora_r4"

gpu_id=2

echo "Lora Config: vb_lora_r=4"

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "Start tuning on gpu: $gpu_id, $current_time"

CUDA_VISIBLE_DEVICES=$gpu_id python rebuttal/baseline/vblora_fine_tune.py \
   --base_model $base_model \
   --data_path yahma/alpaca-cleaned \
   --output_dir rebuttal/tune_log/$target_module/$tune_ckpt_path/ \
   --lora_r 4 \
   --num_epochs 2 \
   --learning_rate 1e-4 \
   --batch_size 64

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "End tuning on gpu: $gpu_id, $current_time"
