#!/bin/bash
export PYTHONPATH='.'


base_model="Meta-Llama-3-8B"
target_module="inter_only/qkvupdown"

step=800
modes=(
  "kron"
  "kron"
  "kron"
  "kron"
)

gpu_ids=(4 5 6 7)

local_rs=(0 0 0 0)
intra_rs=(0 0 0 0)
inter_rs=(16 32 64 128)

run_tuning_and_evaluation(){

  local mode=$1
  local local_r=$2
  local intra_r=$3
  local inter_r=$4
  local gpu_id=$5

  tune_ckpt_path="share_$mode"

  echo "mode: $mode"
  echo "Lora Config: local_r=($local_r), intra_r=($intra_r), inter_r=($inter_r)"

  current_time=$(date "+%Y-%m-%d %H:%M:%S")
  echo "Start tuning on gpu: $gpu_id, $current_time"

  CUDA_VISIBLE_DEVICES=$gpu_id python baseline/sharelora_fine_tune.py \
     --base_model $base_model \
     --data_path yahma/alpaca-cleaned \
     --output_dir tune_log/$target_module/$tune_ckpt_path/${local_r}_${intra_r}_${inter_r}/ \
     --local_r $local_r \
     --intra_r $intra_r \
     --inter_r $inter_r \
     --share_mode $mode \
     --num_epochs 2 \
     --learning_rate 1e-4 \
     --batch_size 64

  current_time=$(date "+%Y-%m-%d %H:%M:%S")
  echo "End tuning on gpu: $gpu_id, $current_time"


  current_time=$(date "+%Y-%m-%d %H:%M:%S")
  echo "Start evaluation on gpu: $gpu_id, $current_time"

  CUDA_VISIBLE_DEVICES=$gpu_id lm_eval --model hf \
      --model_args peft=tune_log/$target_module/$tune_ckpt_path/${local_r}_${intra_r}_${inter_r}/checkpoint-$step,pretrained=$base_model \
      --tasks openbookqa,arc_easy,winogrande,hellaswag,arc_challenge,piqa,social_iqa,boolq \
      --device cuda:0 \
      --output_path results/$target_module/reasoning/${tune_ckpt_path}_${local_r}_${intra_r}_${inter_r}_$step.json

  current_time=$(date "+%Y-%m-%d %H:%M:%S")
  echo "End evaluation on gpu: $gpu_id, $current_time"
}

for i in "${!gpu_ids[@]}"; do
    mode=${modes[$id]}
    local_r=${local_rs[$i]}
    intra_r=${intra_rs[$i]}
    inter_r=${inter_rs[$i]}
    gpu_id=${gpu_ids[$i]}

    run_tuning_and_evaluation "$mode" "$local_r" "$intra_r" "$inter_r" "$gpu_id"&
done
wait  # Wait for all tuning and evaluation processes to finish
