#!/bin/bash
export PYTHONPATH='.'

base_model="baffo32/decapoda-research-llama-7B-hf"
target_module="qkvupdown"
tune_ckpt_path="vera_r64"


step=800
gpu_id=1


echo "Lora Config: vera_r=64"

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "Start tuning on gpu: $gpu_id, $current_time"

CUDA_VISIBLE_DEVICES=$gpu_id python baseline/vera_fine_tune.py \
   --base_model $base_model \
   --data_path yahma/alpaca-cleaned \
   --output_dir tune_log/$target_module/$tune_ckpt_path/ \
   --lora_r 64 \
   --num_epochs 2 \
   --learning_rate 1e-4 \
   --batch_size 64

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "End tuning on gpu: $gpu_id, $current_time"


current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "Start evaluation on gpu: $gpu_id, $current_time"
#export HF_ALLOW_CODE_EVAL=1

CUDA_VISIBLE_DEVICES=$gpu_id lm_eval --model hf \
    --model_args peft=tune_log/$target_module/$tune_ckpt_path/checkpoint-$step,pretrained=$base_model \
    --tasks mmlu,bbh,drop,humaneval \
    --device cuda:0 \
    --output_path results/$target_module/instruct/${tune_ckpt_path}_$step.json

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "End evaluation on gpu: $gpu_id, $current_time"
#--tasks mmlu,bbh,drop,humaneval \
# cola,mnli,mrpc,qnli,qqp,rte,sst2,wnli
# --tasks openbookqa,arc_easy,winogrande,hellaswag,arc_challenge,piqa,social_iqa,boolq \