#!/bin/bash
export PYTHONPATH='.'

base_model="models--baffo32--decapoda-research-llama-7B-hf/snapshots/aa18b48a1330572a6dd5f5d5619ed19838ca285c"
target_module="qkvupdown"

modes=(
  "slice"
  "gate"
  "kron"
)

local_r=2
intra_r=4
inter_r=8

gpu_id=3

run_tuning_and_evaluation(){

  local mode=$1
  tune_ckpt_path="share_$mode"

  echo "mode: $mode"
  echo "Lora Config: local_r=(${local_r}), intra_r=(${intra_r}), inter_r=(${inter_r})"

  current_time=$(date "+%Y-%m-%d %H:%M:%S")
  echo "Start tuning on gpu: $gpu_id, $current_time"

  CUDA_VISIBLE_DEVICES=$gpu_id python rebuttal/baseline/sharelora_fine_tune.py \
     --base_model $base_model \
     --data_path yahma/alpaca-cleaned \
     --output_dir rebuttal/tune_log/$target_module/$tune_ckpt_path/${local_r}_${intra_r}_${inter_r}/ \
     --local_r ${local_r} \
     --intra_r ${intra_r} \
     --inter_r ${inter_r} \
     --share_mode $mode \
     --num_epochs 2 \
     --learning_rate 1e-4 \
     --batch_size 64

  current_time=$(date "+%Y-%m-%d %H:%M:%S")
  echo "End tuning on gpu: $gpu_id, $current_time"
}

for i in "${!modes[@]}"; do
    mode=${modes[$i]}
    run_tuning_and_evaluation "$mode"
done
wait  # Wait for all tuning and evaluation processes to finish

