#!/bin/bash
export PYTHONPATH='.'

base_model="baffo32/decapoda-research-llama-7B-hf"
target_module="qkvupdown"
#tune_ckpt_path="share_lora"
tune_ckpt_path="standard_lora_8"
step=800
gpu_id=2


current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "Start evaluation on gpu: $gpu_id, $current_time"

tune_id="${tune_ckpt_path##*/}"
CUDA_VISIBLE_DEVICES=$gpu_id python lm-evaluation-harness/main.py \
    --model hf-causal-experimental \
    --model_args peft=tune_log/$target_module/$tune_ckpt_path/checkpoint-$step,pretrained=$base_model \
    --tasks gsm8k,mmlu \
    --device cuda:0 \
    --output_path results/$target_module/${tune_id}_mmlu_$step.json \
    --no_cache

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "End evaluation on gpu: $gpu_id, $current_time"
