#!/bin/bash
export PYTHONPATH='.'

base_model="models--Qwen-Qwen2.5-7B-Instruct/"
target_module="qwen/qkvupdown"
tune_ckpt_path="vera_r64"

step=800
gpu_id=1

echo "Lora Config: vera_r=64"

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "Start tuning on gpu: $gpu_id, $current_time"
CUDA_VISIBLE_DEVICES=$gpu_id python baseline/qwen/vera_fine_tune.py \
   --base_model $base_model \
   --data_path yahma/alpaca-cleaned \
   --output_dir tune_log/$target_module/$tune_ckpt_path/ \
   --lora_r 64 \
   --num_epochs 2 \
   --learning_rate 1e-4 \
   --batch_size 64

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "End tuning on gpu: $gpu_id, $current_time"

# ------------- reasoning ---------
current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "Start evaluation on gpu: $gpu_id, $current_time"

CUDA_VISIBLE_DEVICES=$gpu_id lm_eval --model hf \
    --model_args peft=tune_log/$target_module/$tune_ckpt_path/checkpoint-$step,pretrained=$base_model \
    --tasks openbookqa,arc_easy,winogrande,hellaswag,arc_challenge,piqa,social_iqa,boolq \
    --device cuda:0 \
    --output_path results/$target_module/reasoning/${tune_ckpt_path}_$step.json

current_time=$(date "+%Y-%m-%d %H:%M:%S")
echo "End evaluation on gpu: $gpu_id, $current_time"
