import random
import os
from pathlib import Path
import numpy as np

class Run:
    def __init__(self, num, val_ll, val_hamming, test_ll, test_hamming):
        self.num=num
        self.val_ll=val_ll
        self.val_hamming=val_hamming
        self.test_ll=test_ll
        self.test_hamming=test_hamming


baselines = ['LSTM-forecaster']
datasets = ['har_70']

def get_best(baseline, dataset):
    runs = []
    path = './%s/%s'%(baseline, dataset)
    for item in os.listdir(path):
        if os.path.isdir(path + '/' + item):
            for i in range(3):
                if os.path.isfile(path + '/' + item + '/checkpoint_%d.npz'%i):
                    checkpoint = np.load(path + '/' + item + '/checkpoint_%d.npz'%i)
                    runs.append(Run(num=item, 
                                val_ll=checkpoint['val_loglik'][-1], 
                                val_hamming=checkpoint['validation_hammings'][-1],
                                test_ll=checkpoint['loglik'][-1],
                                test_hamming=checkpoint['test_hammings'][-1]))
    return runs
    

for baseline in baselines:
    for dataset in datasets:
        if baseline=='ds-hdp-hmm' and dataset=='CPAP':
            continue
        print('============== BASELINE: %s  DATASET: %s  ============'%(baseline, dataset))
        runs = get_best(baseline, dataset)
        n = 3
        print('Top %d by LL'%n)
        best_lls = runs.sort(key=lambda x: x.val_ll, reverse=True)
        for run in runs[:n]:
            print('Name: ' + run.num + ' val ll: ' + str(run.val_ll) + ' val hamming: ' + str(run.val_hamming) + ' test ll: ' + str(run.test_ll) + ' test hamming: ' + str(run.test_hamming))

        print()
        print('Top %d by Hamming'%n)
        best_hammings = runs.sort(key=lambda x: x.val_hamming, reverse=False)
        for run in runs[:n]:
            print('Name: ' + run.num + ' val ll: ' + str(run.val_ll) + ' val hamming: ' + str(run.val_hamming) + ' test ll: ' + str(run.test_ll) + ' test hamming: ' + str(run.test_hamming))

        print('========================================================')


