# this is the script to run the utility evaluations

cd ..
# activate your environment -> you may install packages from requirements.txt 
# and install an editable version of the transformer folder
source .venv/bin/activate
cd bless_curse_finetune

export CUDA_VISIBLE_DEVICES=0,1,2,3

layer=-1
fact=0.5
proj_init=+FJLT
k_dim=96
dataset=gsm8k
evaluator=gsm8k

accelerate launch --num_processes=4 \
    eval_utility.py \
    --torch_dtype=bfloat16 \
    --model_name_or_path logs/fine-tuning-attack/pure_good/model_path \
    --dataset ${dataset} \
    --model_family='gemma' \
    --prompt_style='gemma' \
    --evaluator ${evaluator} \
    --save_path="logs/fine-tuning-attack/utility_eval/model_path" \
    --k_dim $k_dim \
    --q_factor 2 \
    --fixed_PHD 1 \
    --head 0 \
    --proj_num_heads 1 \
    --proj_train 0 \
    --proj_init $proj_init \
    --proj_layers ALL \
    --proj_layer $layer \
    --proj_factor $fact 
