# this is the script to run the Llama2-7B-Chat-Bottleneck model

cd ..
# activate your environment -> you may install packages from requirements.txt 
# and install an editable version of the transformer folder
source .venv/bin/activate
cd bless_curse_finetune

export CUDA_VISIBLE_DEVICES=0,1,2,3

q_factor=-1
fixed_PHD=0
proj_init=+None
layer=0
fact=0.5

accelerate launch --config_file=accelerate_configs/deepspeed_zero2.yaml \
  --num_processes 4 \
  --main_process_port 12345 \
  finetune.py --model_name_or_path="meta-llama/Llama-2-7b-chat-hf" \
  --dataset_name="pure_good" --model_family='llama2' \
  --learning_rate=1e-5 \
  --per_device_train_batch_size=4 \
  --gradient_accumulation_steps=1 \
  --output_dir="logs/fine-tuning-attack/pure_good/model_path" \
  --logging_steps=1 \
  --num_train_epochs=30 \
  --gradient_checkpointing \
  --report_to=none \
  --torch_dtype=bfloat16 --bf16=True --bf16_full_eval=True \
  --save_strategy='no' \
  --sft_type="sft" \
  --beta=0.1 \
  --bias_factor=20 \
  --first_token_bias_factor=5 \
  --bias_length=5 \
  --use_warmup=False \
  --k_dim -1 \
  --q_factor $q_factor \
  --fixed_PHD $fixed_PHD \
  --head 0 \
  --proj_num_heads 0 \
  --proj_train 0 \
  --proj_init $proj_init \
  --proj_layers ALL \
  --proj_layer $layer \
  --proj_factor $fact \
  --use_anchor=True \
  --anchor_batch_size_per_device=16

cd ..
cd bless_curse_jailbreak

export CUDA_VISIBLE_DEVICES=0

python3 -m pipeline.run_pipeline --model_path bless_curse_finetune/logs/fine-tuning-attack/pure_good/model_path \
    --k_dim -1 --q_factor -1 --fixed_PHD 0 --head 0 --proj_init gen${proj_init} --proj_layers ALL --proj_num_heads 1 \
   --proj_train 0 --proj_layer $layer --proj_factor $fact

