# this is the script to run the Gemma-1.1-7B-IT-FJLT model

cd ..
# activate your environment -> you may install packages from requirements.txt 
# and install an editable version of the transformer folder
source .venv/bin/activate
cd bless_curse_finetune

export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6

fact=1.0
q_factor=-1
fixed_PHD=1
proj_init=+None
k_dim=-1
head=-1
layer=0

accelerate launch --config_file=accelerate_configs/deepspeed_zero2.yaml \
  --num_processes 6 \
  --main_process_port 12345 \
  finetune.py --model_name_or_path="google/gemma-1.1-7b-it" \
  --dataset_name="pure_good" --model_family='gemma' \
  --learning_rate=2e-5 \
  --per_device_train_batch_size=8 \
  --gradient_accumulation_steps=1 \
  --output_dir="logs/fine-tuning-attack/pure_good/model_path" \
  --logging_steps=1 \
  --num_train_epochs=5 \
  --gradient_checkpointing \
  --report_to=none \
  --torch_dtype=bfloat16 --bf16=True --bf16_full_eval=True \
  --save_strategy='no' \
  --sft_type="soft_sft" \
  --beta=0.1 \
  --bias_factor=20 \
  --first_token_bias_factor=5 \
  --bias_length=5 \
  --use_warmup=True \
  --k_dim $k_dim \
  --q_factor $q_factor \
  --fixed_PHD $fixed_PHD \
  --head $head \
  --proj_num_heads 1 \
  --proj_train 0 \
  --proj_init $proj_init \
  --proj_layers ALL \
  --proj_layer $layer \
  --proj_factor $fact \

cd ..
cd bless_curse_jailbreak

export CUDA_VISIBLE_DEVICES=0

python3 -m pipeline.run_pipeline --model_path bless_curse_finetune/logs/fine-tuning-attack/pure_good/model_path \
    --k_dim $k_dim --q_factor $q_factor --fixed_PHD $fixed_PHD --head $head --proj_init gen${proj_init} --proj_layers ALL --proj_num_heads 1 \
   --proj_train 0 --proj_layer $layer --proj_factor $fact --epoch $i

