
## Steps to Run the Project


###  Setting up Environment


1. **Initialize the Environment**  
   Run the `init_env.sh` script to set up the environment.  
   ```bash
   cd provable_circuits;
   ./init_env.sh
   
2. **Activate the Environment**
   ```bash
   source venv/bin/activate

### Define & Run Your Experiments

1. **Create or modify a configuration file**  
   Write your experiment settings in a `.yaml` file (e.g., `exp_conf.yaml`).  
   See `./experiments_config.yaml` for example definitions.

2. **Run the experiments**  
   Execute your configuration with:
   ```bash
   python3 main.py --expconf exp_conf.yaml

**Note:**
For using a custom robustness metrics (winner-runner, winner-diff, etc.), replace the default:  
`alpha-beta-CROWN/specification.py`  
with the customized version of `./external/custom_ab_specification.py`.
