# Personal Social
`PATH_TO_TASK_DIR` is a path to an individual task within a dataset directory for:
- `tasks/brightkite/checkin_prediction/`
- `tasks/gowalla/checkin_prediction/`

# BERT
```
python sequence_model.py --input_path ${PATH_TO_TASK_DIR}/ --num_epochs 10 --experiment_name plain-seq --batch_size 1024 --eval_every 1 --loss_type binary --learning_rate 3e-4 --negative_sampler optimized --gpu_id 0
```

# BERT+node2vec post 
```
# Create node2vec embedding
python node2vec_embedding.py --csv_file ${PATH_TO_TASK_DIR}/relational.csv --learning_rate 1e-3 --gpu_id 0 --seed ${SEED}

# Use node2vec embedding
python sequence_model.py --input_path ${PATH_TO_TASK_DIR}/ --num_epochs 10 --experiment_name seq-n2v-post --batch_size 1024 --eval_every 1 --loss_type binary --learning_rate 3e-4 --graph_embedding_mode post --graph_embedding_file ${STORED_DIR}/node_embeddings.pkl --negative_sampler optimized --gpu_id 0
```

# BERT+node2vec input 
```
# Create node2vec embedding
python node2vec_embedding.py --csv_file ${PATH_TO_TASK_DIR}/relational.csv --learning_rate 1e-3 --gpu_id 0 --seed ${SEED}

# Use node2vec embedding
python sequence_model.py --input_path ${PATH_TO_TASK_DIR}/ --num_epochs 10 --experiment_name seq-n2v-input --batch_size 1024 --eval_every 1 --loss_type binary --learning_rate 3e-4 --graph_embedding_mode input --graph_embedding_file ./stored/node_embeddings.pkl --negative_sampler optimized --seed ${SEED} --gpu_id 0
```

# GCN/GAT personal only
```
python static_graph_pr_nodes.py --base_path ${PATH_TO_TASK_DIR}/ --lr 1e-3 --experiment_name PR-GCN --model GCN --gpu_id 0
```

# GCN/GAT personal+relational
```
python static_graph_pr_nodes.py --base_path ${PATH_TO_TASK_DIR}/ --lr 1e-3 --experiment_name PR-GAT --model GAT --gpu_id 0 --seed ${SEED} --heads 2 --hidden_channels 64
```

# DyRep/TGN personal only
```
python temporal_graph.py --model DyRep --base_path ${PATH_TO_TASK_DIR}/ --lr 1e-3 --no_relational --experiment_name DyRep-P --seed ${SEED} --gpu_id 0 --embedding_dim 32
```

# DyRep/TGN personal+relational
```
python temporal_graph.py --model DyRep --base_path ${PATH_TO_TASK_DIR}/ --lr 1e-3 --experiment_name DyRep-PR --seed ${SEED} --gpu_id 0 --embedding_dim 32
```