# Relational Amazon
`PATH_TO_TASK_DIR` is a path to an individual task within a dataset directory for:
- `tasks/amazon-clothing/coreview_prediction/`
- `tasks/amazon-electronics/coreview_prediction/`

## GCN/GAT relational only
```
python static_graph.py\
            --base_path ${PATH_TO_TASK_DIR}\
            --seed 42\
            --model GAT\
            --experiment_name 'relational_only'\
            --epochs 20
```

## GCN/GAT relational+personal
```
python static_graph_personal_nodes.py\
            --base_path ${PATH_TO_TASK_DIR}\
            --seed 42\
            --model GAT\
            --experiment_name 'with_seq_features'\
            --eval_batch_size 16384\
            --epochs 20
```

## GCN/GAT + sequence embedding
```
# Generate sequence embeddings
python sequence_embedding.py \
            --csv_file ${PATH_TO_TASK_DIR}personal_observed.csv\
            --learning_rate 1e-3 --mask_prob 0.3\
            --batch_size 32\
            --embedding_file amazon-user_embedding-m0.3-lr1e-4.pkl\
            --model_file amazon-trained_model-m0.3-lr1e-4.pth
# Use sequence embeddings
python static_graph.py\
            --base_path ${PATH_TO_TASK_DIR}\
            --seed 42\
            --model GAT\
            --experiment_name 'with_seq_embedding'\
            --use_sequence_embedding\
            --seq_embedding_filename ./stored/amazon-user_embedding-m0.3-lr1e-4.pkl\
            --epochs 20
```

## TGN/DyRep relational+personal
```
python temporal_graph.py\
            --base_path ${PATH_TO_TASK_DIR}\
            --seed 42\
            --model TGN\
            --experiment_name 'temporal_tgn'\
            --embedding_dim 128\
            --epochs 20
```
